/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.php.internal.builder.preferences;

import com.aptana.editor.php.internal.builder.IPHPLibrary;
import com.aptana.editor.php.internal.builder.LibraryManager;
import com.aptana.editor.php.internal.builder.preferences.DependenciesManager;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;

public class ProjectDependencies {
    private List<File> directories = new ArrayList<File>();
    private List<IResource> workspaceResources = new ArrayList<IResource>();
    private List<String> librariesIds = new ArrayList<String>();
    private boolean usesCustomLibs;

    public List<String> getNotUsedLibrariesIds() {
        return this.librariesIds;
    }

    public void setNotUsedLibrariesIds(List<String> librariesIds) {
        this.librariesIds = librariesIds;
    }

    public boolean isUsesCustomLibs() {
        return this.usesCustomLibs;
    }

    public void setUsesCustomLibs(boolean usesCustomLibs) {
        this.usesCustomLibs = usesCustomLibs;
    }

    public void load(String persistentProperty) {
        if (persistentProperty != null) {
            String[] pEntries = persistentProperty.split(File.pathSeparator);
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            String[] stringArray = pEntries;
            int n = pEntries.length;
            int n2 = 0;
            while (n2 < n) {
                String f = stringArray[n2];
                if (f.length() != 0) {
                    String path;
                    IResource resource;
                    if (f.charAt(0) == 'f') {
                        this.directories.add(new File(DependenciesManager.descape(f.substring(1))));
                    } else if (f.charAt(0) == 'p' && (resource = root.findMember(path = DependenciesManager.descape(f.substring(1)))) != null) {
                        this.workspaceResources.add(resource);
                    }
                }
                ++n2;
            }
        }
    }

    public String toString() {
        String absolutePath;
        StringBuilder bld = new StringBuilder();
        for (File f : this.directories) {
            bld.append('f');
            absolutePath = f.getAbsolutePath();
            absolutePath = DependenciesManager.escape(absolutePath);
            bld.append(absolutePath);
            bld.append(File.pathSeparatorChar);
        }
        for (IResource p : this.workspaceResources) {
            bld.append('p');
            absolutePath = p.getFullPath().toString();
            absolutePath = DependenciesManager.escape(absolutePath);
            bld.append(absolutePath);
            bld.append(File.pathSeparatorChar);
        }
        if (bld.length() > 0) {
            bld.deleteCharAt(bld.length() - 1);
        }
        return bld.toString();
    }

    public List<File> getDirectories() {
        return new ArrayList<File>(this.directories);
    }

    public List<IResource> getWorkspaceResources() {
        return new ArrayList<IResource>(this.workspaceResources);
    }

    public void set(List<IResource> ps, List<File> fs) {
        this.directories = new ArrayList<File>(fs);
        this.workspaceResources = new ArrayList<IResource>(ps);
    }

    public void loadLibs(String persistentProperty) {
        if (persistentProperty == null || persistentProperty.length() == 0) {
            this.usesCustomLibs = false;
            this.librariesIds.clear();
            return;
        }
        char charAt = persistentProperty.charAt(0);
        this.usesCustomLibs = charAt == 'y';
        String[] split = persistentProperty.substring(1).split(File.pathSeparator);
        int a = 0;
        while (a < split.length) {
            IPHPLibrary library = LibraryManager.getInstance().getLibrary(split[a].trim());
            if (library != null) {
                this.librariesIds.add(library.getId());
            }
            ++a;
        }
    }

    public String getLibString() {
        StringBuilder bld = new StringBuilder();
        if (this.usesCustomLibs) {
            bld.append('y');
        } else {
            bld.append('n');
        }
        for (String s : this.librariesIds) {
            bld.append(s);
            bld.append(File.pathSeparator);
        }
        if (this.librariesIds.size() > 0) {
            bld.deleteCharAt(bld.length() - 1);
        }
        return bld.toString();
    }
}

